ace.define("ace/mode/pv_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],
function(require, exports, module) {
"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var escapeRe = "\\\\(?:[\\\\0abtrn;#=:]|x[a-fA-F\\d]{4})";

var PVHighlightRules = function() {
    this.$rules = {
        start: [{
            token: 'comment.pv',
            regex: '[#;].*',
            push_: [{
                token: 'comment.line.number-sign.pv',
                regex: '$|^',
                next: 'pop'
            }, {
                defaultToken: 'comment.line.number-sign.pv'
            }]
        }, {
            token: 'section.pv',
            regex: '^:[\\w,]+',
        }, {
            token: 'expression.pv',
            regex: '\\(.+\\)',
        }, {
            token: ['definition.pv', 'separator.pv', 'section.pv'],
            regex: '(do|else|err|error|fallback|fb|go|goto|ifd|ifdisabled|ife|ifenabled|ifbg|ifbigger|iferror|iffound|ifl|iflong|ifmatch|ifminsp|ifminspread|ifmaxsp|ifmaxspread|ifn|ifnp|ifnnp|ifnone|ifnomatch|ifnomatchpos|ifnomatchnopos|ifnonepos|ifnonenopos|ifnoorder|ifnopos|ifnot|ifo|ifopen|iforder|ifp|ifpartial|ifpos|ifr|ifreject|ifrejected|ifs|ifshort|ifsl|ifslp|ifslnp|ifslip|ifslippos|ifslipnopos|ifsm|ifsmaller|ift|ift|iftf|iftime|iftimefill|iftimenofill|iftimenopos|iftimeout|iftimepos|iftnf|iftnp|iftp|jump|loop|noorder|nopos|nr|onerror|skip|wid|wrongid|wrongside|ws)(=)([a-zA-Z]\\w+)\\b'
        }, {
            token: ['definition.pv', 'separator.pv'],
            //regex: '\\b([\\w]+)\\b(=)'
            regex: '([\\w]+)(=)'
        }, {
            token: ['entity.pv', 'keyword.pv', 'entity.pv'],
            regex: '(\\[)(.*?)(\\])'
        }, {
            token: 'string.begin.pv',
            regex: '"',
            push: [{
                token: "constant.language.escape",
                regex: escapeRe
            }, {
                token: 'string.end.pv',
                regex: '"',
                next: 'pop'
            }, {
                defaultToken: 'string.quoted.double.pv'
            }]
        }]
    };
    this.normalizeRules();
};

PVHighlightRules.metaData = {
    fileTypes: ['pv', 'conf'],
    keyEquivalent: '^~I',
    name: 'PV',
    scopeName: 'source.pv'
};
oop.inherits(PVHighlightRules, TextHighlightRules);
exports.PVHighlightRules = PVHighlightRules;
})
,ace.define("ace/mode/folding/pv",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(e,t,n){"use strict";var r=e("../../lib/oop"),i=e("../../range").Range,s=e("./fold_mode").FoldMode,o=t.FoldMode=function(){};r.inherits(o,s),function(){this.foldingStartMarker=/^\s*\[([^\])]*)]\s*(?:$|[;#])/,this.getFoldWidgetRange=function(e,t,n){var r=this.foldingStartMarker,s=e.getLine(n),o=s.match(r);if(!o)return;var u=o[1]+".",a=s.length,f=e.getLength(),l=n,c=n;while(++n<f){s=e.getLine(n);if(/^\s*$/.test(s))continue;o=s.match(r);if(o&&o[1].lastIndexOf(u,0)!==0)break;c=n}if(c>l){var h=e.getLine(c).length;return new i(l,a,c,h)}}}.call(o.prototype)}),ace.define("ace/mode/pv",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/pv_highlight_rules","ace/mode/folding/pv"],function(e,t,n){"use strict";var r=e("../lib/oop"),i=e("./text").Mode,s=e("./pv_highlight_rules").PVHighlightRules,o=e("./folding/pv").FoldMode,u=function(){this.HighlightRules=s,this.foldingRules=new o,this.$behaviour=this.$defaultBehaviour};r.inherits(u,i),function(){this.lineCommentStart="#",this.blockComment=null,this.$id="ace/mode/pv"}.call(u.prototype),t.Mode=u});                (function() {
                    ace.require(["ace/mode/pv"], function(m) {
                        if (typeof module == "object" && typeof exports == "object" && module) {
                            module.exports = m;
                        }
                    });
                })();
            